let on = false;
let startButton;
let mic;
let fft;
let amp;
let stars = [];
let numStars = 100;
let soundEffect;
let mouseTrail = [];

function preload() {
    soundEffect = loadSound('glass.mp3'); 
}

function setup() {
    let canvas = createCanvas(windowWidth, windowHeight);
    canvas.parent('header');
    
    noFill();
    colorMode(HSB);
    strokeCap(ROUND);

    for (let i = 0; i < numStars; i++) {
        stars.push(new Star(random(width), random(height), random(10, 40)));
    }

    startButton = createButton('Click to start microphone visualization')
        .size(400, 60)
        .style('font-size', '18px')
        .style('color', '#fff')
        .style('background-color', "#333")
        .style('text-align', 'center')
        .style('border', '2px solid #fff')
        .style('cursor', 'pointer')
        .mouseOver(() => startButton.style('background-color', "#555"))
        .mouseOut(() => startButton.style('background-color', "#333"))
        .position((windowWidth / 2) - 200, windowHeight / 3, 'relative')
        .mousePressed(turnOn);
}

function turnOn() {
    on = true;
    mic = new p5.AudioIn();
    mic.start();
    fft = new p5.FFT(0.6, 1024);
    fft.setInput(mic);
    amp = new p5.Amplitude();
    amp.setInput(mic);
    startButton.remove();
}

function draw() {
    background(0);
    if (on) {
        let level = amp.getLevel();
        
        for (let i = 0; i < stars.length; i++) {
            stars[i].update(level);
            stars[i].show();
        }
    }

    
    mouseTrail.push({x: mouseX, y: mouseY});
    if (mouseTrail.length > 20) mouseTrail.shift(); 

    noFill();
    stroke(70, 30, 325);
    strokeWeight(5);
    beginShape();
    for (let point of mouseTrail) {
        vertex(point.x, point.y);
    }
    endShape();
}

class Star {
    constructor(x, y, size) {
        this.x = x;
        this.y = y;
        this.baseSize = size;
        this.size = size;
        this.brightness = 0;
        this.blinkTimer = random(30, 100);
    }
    
    update(level) {
        this.brightness = map(level, 0, 1, 50, 255);
        this.size = lerp(this.size, map(level, 0, 1, this.baseSize, this.baseSize * 2), 0.1);

  
        this.x += random(-1, 1);
        this.y += random(-1, 1);


        this.blinkTimer--;
        if (this.blinkTimer <= 0) {
            this.brightness = this.brightness > 150 ? 0 : 255;
            this.blinkTimer = random(30, 100);
        }
    }
    
    show() {
        push();
        translate(this.x, this.y);
        fill(random(200, 360), 255, this.brightness);
        stroke(255);
        strokeWeight(2);
        this.drawStar(0, 0, this.size / 2, this.size, 5);
        pop();
    }
    
    drawStar(x, y, radius1, radius2, npoints) {
        let angle = TWO_PI / npoints;
        let halfAngle = angle / 2.0;
        beginShape();
        for (let a = 0; a < TWO_PI; a += angle) {
            let sx = x + cos(a) * radius2;
            let sy = y + sin(a) * radius2;
            vertex(sx, sy);
            sx = x + cos(a + halfAngle) * radius1;
            sy = y + sin(a + halfAngle) * radius1;
            vertex(sx, sy);
        }
        endShape(CLOSE);
    }

    checkMouseOver(mx, my) {
        let d = dist(mx, my, this.x, this.y);
        if (d < this.size / 2) {
            this.size += 10;
            if (soundEffect.isLoaded()) {
                soundEffect.play();
            }
        }
    }
}

function mouseClicked() {
    for (let i = 0; i < stars.length; i++) {
        stars[i].checkMouseOver(mouseX, mouseY);
    }

    if (mouseX > 0 && mouseX < width && mouseY > 0 && mouseY < height) {
        if (getAudioContext().state !== 'running') {
            getAudioContext().resume();
        }
    }
}
